
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

//#include <atomic>
#include <gdiplus.h>

#include <combaseapi.h>


using namespace Gdiplus;


#define FRAME_W 20
#define FRAME_H 43


#define WIDTHBYTES_COUNT	(bitcount, w)	((((w)*(bitcount)+31) & ~31) >> 3)
#define WIDTHBYTES(bitcount) (((bitcount)+31)/32*4) // ??? ???? 4???? ??


#define BYTE unsigned char 


typedef struct DF_BITMAP
{
	BYTE * p;
	int w;
	int h;
	int rw;
}ST_BITMAP;

ST_BITMAP *b1, *b2;


/*
1920 x 1080  JPG BMP   A   DATA
1920 x 1080  JPG       B   ENC
1920 x 1080  JPG       C   DEC DATA
A - C = D

1024 x 768   JPG   E   ENC
1024 x 768   JPG   F   DEC DATA
A - F = G

https://docs.microsoft.com/en-us/windows/win32/api/wingdi/nf-wingdi-getdibits

https://docs.microsoft.com/en-us/windows/win32/api/combaseapi/nf-combaseapi-couninitialize


https://docs.microsoft.com/en-us/windows/win32/api/combaseapi/nf-combaseapi-createstreamonhglobal

--std=c++14 -std=c++11 -std=gnu++11
-pedantic -pthread -lwinmm -lgdi32 
-lgdiplus -lcomctl32
-lgdi32 -lcomctl32
https://blog.csdn.net/meegomeego/article/details/8178791
-mwindows
-std=c++11

"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libwinmm.a"
"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libgdi32.a"
"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libcomctl32.a"
"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libimm32.a"
"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib/libgdiplus.a"

"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib/libgdiplus.a"

"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libgdiplus.a"
"../../../Program Files (x86)/Dev-Cpp/MinGW64/x86_64-w64-mingw32/lib32/libmfcuia32.a"


Image class
https://docs.microsoft.com/en-us/windows/win32/api/gdiplusheaders/nl-gdiplusheaders-image

*/


//http://www.devpia.com/MAEUL/Contents/Detail.aspx?BoardID=50&MAEULNo=20&no=665211&ref=665170


int GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
   UINT  num = 0;          // number of image encoders
   UINT  size = 0;         // size of the image encoder array in bytes

   ImageCodecInfo* pImageCodecInfo = NULL;

   GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;  // Failure

   pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;  // Failure

   GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;  // Success
      }    
   }

   free(pImageCodecInfo);
   return -1;  // Failure
}



int fnConvert(HDC hdc)
{
	
		char buf[200];
		memset(buf, 0x00, 200);
		
		
//		WCHAR wstr[100];
//		wsprintf((LPSTR)&wstr[0], "123A.jpg");
//		Image image(wstr);
		Image image(L"testA.bmp");

//		Image newImage = Gdiplus::Image::FromFile("123.jpg");


		// Create stream with 0 size
		IStream* pIStream = NULL;
		if (CreateStreamOnHGlobal(NULL, TRUE, (LPSTREAM*)&pIStream) != S_OK)
		{
			::MessageBox(NULL, "Failed to create stream on global memory!","", MB_OK);
			return 0;
		}

		// Get encoder class id for jpg compression
		// for other compressions use 
		//     image/bmp 
		//     image/jpeg 
		//     image/gif 
		//     image/tiff 
		//     image/png 

		CLSID pngClsid;
		GetEncoderClsid(L"image/jpeg", &pngClsid);

		// Setup encoder parameters
		EncoderParameters encoderParameters;
		encoderParameters.Count = 1;
		encoderParameters.Parameter[0].Guid = EncoderQuality;
		encoderParameters.Parameter[0].Type = EncoderParameterValueTypeLong;
		encoderParameters.Parameter[0].NumberOfValues = 1;

		// setup compression level
		ULONG quality = 100;
		encoderParameters.Parameter[0].Value = &quality;

		//  Save the image to the stream
		Status SaveStatus = image.Save(pIStream, &pngClsid, &encoderParameters);
		if (SaveStatus != Ok)
		{
			// this shoud free global memory used by the stream
			// according to MSDN
			pIStream->Release();
			//			AfxMessageBox(_T("Failed to save to stream!"));
			::MessageBox(NULL, "Failed to save to stream!","", MB_OK);
			
			return 0;
		}

		// get the size of the stream
		ULARGE_INTEGER ulnSize;
		LARGE_INTEGER lnOffset;
		lnOffset.QuadPart = 0;
		if (pIStream->Seek(lnOffset, STREAM_SEEK_END, &ulnSize) != S_OK)
		{
			pIStream->Release();
			
			::MessageBox(NULL, "Failed to get the size of the stream","", MB_OK);
			return 0;

		}

		// now move the pointer to the begining of the file
		if (pIStream->Seek(lnOffset, STREAM_SEEK_SET, NULL) != S_OK)
		{
			pIStream->Release();
			
			::MessageBox(NULL, "Failed to smove the file pointer to the beginning of the stream!","", MB_OK);
			return 0;
		}


		// I am going to save it to the file just so we can load the jpg to a gfx program
		FILE * fp;
		fp = fopen("testC.jpg", "wb");
		if(fp == NULL)
		{
			// Free memory used by the stream
			pIStream->Release();
			image.~Image();
			::MessageBox(NULL, "Failed to save data to the disk!","", MB_OK);
			return 0;
		}
		else
		{
			char *pBuff = new char[ulnSize.QuadPart];

	
			// Read the stream directly into the buffer
			ULONG ulBytesRead;
			if (pIStream->Read(pBuff, ulnSize.QuadPart, &ulBytesRead) != S_OK)
			{
				pIStream->Release();
				delete pBuff;
				return 0;
			}
//			memcpy(p1, pBuff, ulBytesRead);

			fwrite(pBuff, 1, ulBytesRead, fp);
			fclose(fp);
			delete pBuff;
		}

	Graphics g(hdc);
	g.DrawImage(&image, 0, 0);

		// Free memory used by the stream
		pIStream->Release();
		image.~Image();


		//
//		unlink(str.GetBuffer(str.GetLength()));
//		DeleteFile(buf);
//		DeleteFile(str.GetBuffer(str.GetLength()));




/*
	//
	{
	FILE * fp;
	fp = fopen("test.txt", "wt");
	if(fp == NULL) return 0;
	int i;
	int size = ulnSize.QuadPart;
	for(i=0; i<size; i++)
	{
		if(p1[i] == p2[i])
		{
			char c = ' ';
			fwrite(&c, 1, 1, fp);
		}
		else
		{
			char c = p2[i];
			fwrite(&c, 1, 1, fp);
		}
	}
	fclose(fp);
	}
*/

	return 1;
}





int fn_JPG(HDC hdc)
{
	
		char buf[200];
		memset(buf, 0x00, 200);
		
		
//		WCHAR wstr[100];
//		wsprintf((LPSTR)&wstr[0], "123A.jpg");
//		Image image(wstr);
		Image image(L"123A.jpg");

//		Image newImage = Gdiplus::Image::FromFile("123.jpg");


		// Create stream with 0 size
		IStream* pIStream = NULL;
		if (CreateStreamOnHGlobal(NULL, TRUE, (LPSTREAM*)&pIStream) != S_OK)
		{
			::MessageBox(NULL, "Failed to create stream on global memory!","", MB_OK);
			return 0;
		}

		// Get encoder class id for jpg compression
		// for other compressions use 
		//     image/bmp 
		//     image/jpeg 
		//     image/gif 
		//     image/tiff 
		//     image/png 

		CLSID pngClsid;
		GetEncoderClsid(L"image/jpeg", &pngClsid);

		// Setup encoder parameters
		EncoderParameters encoderParameters;
		encoderParameters.Count = 1;
		encoderParameters.Parameter[0].Guid = EncoderQuality;
		encoderParameters.Parameter[0].Type = EncoderParameterValueTypeLong;
		encoderParameters.Parameter[0].NumberOfValues = 1;

		// setup compression level
		ULONG quality = 100;
		encoderParameters.Parameter[0].Value = &quality;

		//  Save the image to the stream
		Status SaveStatus = image.Save(pIStream, &pngClsid, &encoderParameters);
		if (SaveStatus != Ok)
		{
			// this shoud free global memory used by the stream
			// according to MSDN
			pIStream->Release();
			//			AfxMessageBox(_T("Failed to save to stream!"));
			::MessageBox(NULL, "Failed to save to stream!","", MB_OK);
			
			return 0;
		}

		// get the size of the stream
		ULARGE_INTEGER ulnSize;
		LARGE_INTEGER lnOffset;
		lnOffset.QuadPart = 0;
		if (pIStream->Seek(lnOffset, STREAM_SEEK_END, &ulnSize) != S_OK)
		{
			pIStream->Release();
			
			::MessageBox(NULL, "Failed to get the size of the stream","", MB_OK);
			return 0;

		}

		// now move the pointer to the begining of the file
		if (pIStream->Seek(lnOffset, STREAM_SEEK_SET, NULL) != S_OK)
		{
			pIStream->Release();
			
			::MessageBox(NULL, "Failed to smove the file pointer to the beginning of the stream!","", MB_OK);
			return 0;
		}


		// I am going to save it to the file just so we can load the jpg to a gfx program
		FILE * fp;
		fp = fopen("testC.jpg", "wb");
		if(fp == NULL)
		{
			// Free memory used by the stream
			pIStream->Release();
			image.~Image();
			::MessageBox(NULL, "Failed to save data to the disk!","", MB_OK);
			return 0;
		}
		else
		{
			char *pBuff = new char[ulnSize.QuadPart];

	
			// Read the stream directly into the buffer
			ULONG ulBytesRead;
			if (pIStream->Read(pBuff, ulnSize.QuadPart, &ulBytesRead) != S_OK)
			{
				pIStream->Release();
				delete pBuff;
				return 0;
			}
//			memcpy(p1, pBuff, ulBytesRead);

			fwrite(pBuff, 1, ulBytesRead, fp);
			fclose(fp);
			delete pBuff;
		}

	Graphics g(hdc);
	g.DrawImage(&image, 0, 0);

		// Free memory used by the stream
		pIStream->Release();
		image.~Image();


		//
//		unlink(str.GetBuffer(str.GetLength()));
//		DeleteFile(buf);
//		DeleteFile(str.GetBuffer(str.GetLength()));


	return 1;
}








char	buf[1024];
HBITMAP	hBit;
int		iPtSize	= 18;
int		rwsize	= 0;
char	key		= 0;
char	key_num	= 0;
int		g_val0	= 0;
int		g_val1	= 0;
int		g_val2	= 0;
int		g_val3	= 0;
int		g_val4	= 0;


void fn_DrawBitmap(HDC hdc,int x,int y,HBITMAP hBit)
{
	HDC MemDC;
	HBITMAP OldBitmap;
	int bx,by;
	BITMAP bit;

	MemDC=CreateCompatibleDC(hdc);
	OldBitmap=(HBITMAP)SelectObject(MemDC, hBit);

	GetObject(hBit,sizeof(BITMAP),&bit);
	bx=bit.bmWidth;
	by=bit.bmHeight;

	BitBlt(hdc,0,0,bx,by,MemDC,0,0,SRCCOPY);

	SelectObject(MemDC,OldBitmap);
	DeleteDC(MemDC);
//	printf("%d %d \n", bx, by);
}


// DIB uouCAi ˡˡieui CUieAi ˡcAICNˡU.
HBITMAP MakeDIBSection(char *Path)
{
	HANDLE hFile;
	DWORD FileSize, dwRead;
	BITMAPFILEHEADER fh;
	HBITMAP hBit;
	BITMAPINFO *ih;
	PVOID pRaster;

	// AAIAi ?ˡU
	hFile=CreateFile(Path,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hFile==INVALID_HANDLE_VALUE) {
		return NULL;
	}

	// AAI Ciˡo?I Aˢˡ ˡAOAu(ioio AAIi ACO)ˡ| AˡuiieAIˡU.
	ReadFile(hFile,&fh,sizeof(BITMAPFILEHEADER),&dwRead,NULL);
	FileSize=fh.bfOffBits-sizeof(BITMAPFILEHEADER);
	
	ih=(BITMAPINFO *)malloc(FileSize);
	ReadFile(hFile,ih,FileSize,&dwRead,NULL);

	// DIB uouCAi ˡˡiei ooU ˡˡϡ̡ˡcˡ| COˡcCNˡU.
	hBit=CreateDIBSection(NULL,ih,DIB_RGB_COLORS,&pRaster,NULL,0);

	// ˢ硧oAI iIAIAIˡ| AˡuiieAIˡU.
	ReadFile(hFile,pRaster,fh.bfSize-fh.bfOffBits,&dwRead,NULL);
	free(ih);
	CloseHandle(hFile);

	return hBit;
}







/*
https://docs.microsoft.com/en-us/windows/win32/gdi/capturing-an-image


int CaptureAnImage(HWND hWnd)
{
    HDC hdcScreen;
    HDC hdcWindow;
    HDC hdcMemDC = NULL;
    HBITMAP hbmScreen = NULL;
    BITMAP bmpScreen;

    // Retrieve the handle to a display device context for the client 
    // area of the window. 
    hdcScreen = GetDC(NULL);
    hdcWindow = GetDC(hWnd);

    // Create a compatible DC which is used in a BitBlt from the window DC
    hdcMemDC = CreateCompatibleDC(hdcWindow); 

    if(!hdcMemDC)
    {
        MessageBox(hWnd, L"CreateCompatibleDC has failed",L"Failed", MB_OK);
        goto done;
    }

    // Get the client area for size calculation
    RECT rcClient;
    GetClientRect(hWnd, &rcClient);

    //This is the best stretch mode
    SetStretchBltMode(hdcWindow,HALFTONE);

    //The source DC is the entire screen and the destination DC is the current window (HWND)
    if(!StretchBlt(hdcWindow, 
               0,0, 
               rcClient.right, rcClient.bottom, 
               hdcScreen, 
               0,0,
               GetSystemMetrics (SM_CXSCREEN),
               GetSystemMetrics (SM_CYSCREEN),
               SRCCOPY))
    {
        MessageBox(hWnd, L"StretchBlt has failed",L"Failed", MB_OK);
        goto done;
    }
    
    // Create a compatible bitmap from the Window DC
    hbmScreen = CreateCompatibleBitmap(hdcWindow, rcClient.right-rcClient.left, rcClient.bottom-rcClient.top);
    
    if(!hbmScreen)
    {
        MessageBox(hWnd, L"CreateCompatibleBitmap Failed",L"Failed", MB_OK);
        goto done;
    }

    // Select the compatible bitmap into the compatible memory DC.
    SelectObject(hdcMemDC,hbmScreen);
    
    // Bit block transfer into our compatible memory DC.
    if(!BitBlt(hdcMemDC, 
               0,0, 
               rcClient.right-rcClient.left, rcClient.bottom-rcClient.top, 
               hdcWindow, 
               0,0,
               SRCCOPY))
    {
        MessageBox(hWnd, L"BitBlt has failed", L"Failed", MB_OK);
        goto done;
    }

    // Get the BITMAP from the HBITMAP
    GetObject(hbmScreen,sizeof(BITMAP),&bmpScreen);
     
    BITMAPFILEHEADER   bmfHeader;    
    BITMAPINFOHEADER   bi;
     
    bi.biSize = sizeof(BITMAPINFOHEADER);    
    bi.biWidth = bmpScreen.bmWidth;    
    bi.biHeight = bmpScreen.bmHeight;  
    bi.biPlanes = 1;    
    bi.biBitCount = 32;    
    bi.biCompression = BI_RGB;    
    bi.biSizeImage = 0;  
    bi.biXPelsPerMeter = 0;    
    bi.biYPelsPerMeter = 0;    
    bi.biClrUsed = 0;    
    bi.biClrImportant = 0;

    DWORD dwBmpSize = ((bmpScreen.bmWidth * bi.biBitCount + 31) / 32) * 4 * bmpScreen.bmHeight;

    // Starting with 32-bit Windows, GlobalAlloc and LocalAlloc are implemented as wrapper functions that 
    // call HeapAlloc using a handle to the process's default heap. Therefore, GlobalAlloc and LocalAlloc 
    // have greater overhead than HeapAlloc.
    HANDLE hDIB = GlobalAlloc(GHND,dwBmpSize); 
    char *lpbitmap = (char *)GlobalLock(hDIB);    

    // Gets the "bits" from the bitmap and copies them into a buffer 
    // which is pointed to by lpbitmap.
    GetDIBits(hdcWindow, hbmScreen, 0,
        (UINT)bmpScreen.bmHeight,
        lpbitmap,
        (BITMAPINFO *)&bi, DIB_RGB_COLORS);

    // A file is created, this is where we will save the screen capture.
    HANDLE hFile = CreateFile(L"captureqwsx.bmp",
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL, NULL);   
    
    // Add the size of the headers to the size of the bitmap to get the total file size
    DWORD dwSizeofDIB = dwBmpSize + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
 
    //Offset to where the actual bitmap bits start.
    bmfHeader.bfOffBits = (DWORD)sizeof(BITMAPFILEHEADER) + (DWORD)sizeof(BITMAPINFOHEADER); 
    
    //Size of the file
    bmfHeader.bfSize = dwSizeofDIB; 
    
    //bfType must always be BM for Bitmaps
    bmfHeader.bfType = 0x4D42; //BM   
 
    DWORD dwBytesWritten = 0;
    WriteFile(hFile, (LPSTR)&bmfHeader, sizeof(BITMAPFILEHEADER), &dwBytesWritten, NULL);
    WriteFile(hFile, (LPSTR)&bi, sizeof(BITMAPINFOHEADER), &dwBytesWritten, NULL);
    WriteFile(hFile, (LPSTR)lpbitmap, dwBmpSize, &dwBytesWritten, NULL);
    
    //Unlock and Free the DIB from the heap
    GlobalUnlock(hDIB);    
    GlobalFree(hDIB);

    //Close the handle for the file that was created
    CloseHandle(hFile);
       
    //Clean up
done:
    DeleteObject(hbmScreen);
    DeleteObject(hdcMemDC);
    ReleaseDC(NULL,hdcScreen);
    ReleaseDC(hWnd,hdcWindow);

    return 0;
}
*/







void fn_draw(HWND hWnd, HDC h_screen_dc)
{
	BYTE		*	p_image_data	= NULL;
	BITMAPINFO		dib;
	RECT			rt;

	int				w;
	int				h;

	//
	::GetClientRect(hWnd, &rt);
	w = rt.right - rt.left;
	h = rt.bottom - rt.top;

	// DIBAC CuoAAi AˢACCNˡU.
	dib.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
	dib.bmiHeader.biWidth			= w;
	dib.bmiHeader.biHeight			= h;
	dib.bmiHeader.biPlanes			= 1;
	dib.bmiHeader.biBitCount		= 24;
	dib.bmiHeader.biCompression		= BI_RGB;
	dib.bmiHeader.biSizeImage		= (((w * 24 + 31) & ~31) >> 3) * h;
	dib.bmiHeader.biXPelsPerMeter	= 0;
	dib.bmiHeader.biYPelsPerMeter	= 0;
	dib.bmiHeader.biClrImportant	= 0;
	dib.bmiHeader.biClrUsed			= 0;

	// dib_define?ˢ AˢACiE ϩi?eAˡI DIBˡ| iyuCNˡU.
	HBITMAP h_bitmap = ::CreateDIBSection(h_screen_dc, &dib, DIB_RGB_COLORS, (void **)&p_image_data, 0, 0);

	// AIoIAoˡ| AϡAaCIa ACu ˢ碮io DCˡ| iyuCNˡU. ˡAI DC?ˢ硧uϡˡA AAAEAuAˡI ncˡE?ˢ AEUCI?I
	// AIoIAo AIAi uoAi uo uϨa OocAIˡU.
	HDC h_memory_dc = ::CreateCompatibleDC(h_screen_dc);

	// ˢ碮io DC?ˢ AIoIAoˡ| AϡAaCO ncˡEAi ?aCNˡU.
	HBITMAP h_old_bitmap = (HBITMAP)::SelectObject(h_memory_dc, h_bitmap);

	//
	rwsize = WIDTHBYTES(dib.bmiHeader.biBitCount*w);
	//p_image_data = new BYTE [3*rwsize*hInfo.biHeight];


	//
	int size = dib.bmiHeader.biSizeImage;
//	p2 = (BYTE*) malloc (size);
//	memcpy(p2, p_image_data, size);

	printf("size1 %d \n", size);
	

	//
	int i=0;
	int j=0;
	for(i=0; i<h; i++)
	{
		for(j=0; j<w; j++) 
		{
			int r = rand()%100;
			if(key_num == 0+48)	//0
			{
			}
			if(key_num == 1+48)	//1
			{
				p_image_data[i*rwsize+3*j+2] = 22;
				p_image_data[i*rwsize+3*j+1] = 33;
				p_image_data[i*rwsize+3*j  ] = 44;
			}
			if(key_num == 2+48)	//2
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i;
				p_image_data[i*rwsize+3*j+1] = 33;
				p_image_data[i*rwsize+3*j  ] = 44;
			}
			if(key_num == 3+48)	//3
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i+i;
				p_image_data[i*rwsize+3*j+1] = 33;
				p_image_data[i*rwsize+3*j  ] = 44;
			}
			if(key_num == 4+48)	//4
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i;
				p_image_data[i*rwsize+3*j+1] = 33+j;
				p_image_data[i*rwsize+3*j  ] = 44;
			}
			if(key_num == 5+48)	//5
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i;
				p_image_data[i*rwsize+3*j+1] = 33+j+j;
				p_image_data[i*rwsize+3*j  ] = 44;
			}
			if(key_num == 6+48)	//6
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i;
				p_image_data[i*rwsize+3*j+1] = 33+j+j;
				p_image_data[i*rwsize+3*j  ] = 44+i;
			}
			if(key_num == 7+48)	//7
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i;
				p_image_data[i*rwsize+3*j+1] = 33+j+j;
				p_image_data[i*rwsize+3*j  ] = 44+j;
			}
			if(key_num == 8+48)	//8
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i+j;
				p_image_data[i*rwsize+3*j+1] = 33+j+j;
				p_image_data[i*rwsize+3*j  ] = 44+j+j;
			}
			if(key_num == 9+48)	//9
			{
				p_image_data[i*rwsize+3*j+2] = 22+i+i+j;
				p_image_data[i*rwsize+3*j+1] = 33+i+j;
				p_image_data[i*rwsize+3*j  ] = 44+i+j;
			}
		}
	}

	// CoAc oAIˡ EϡˡeAi AˡAACNˡU.
//	::BitBlt(h_memory_dc, 0, 0, w, h, h_screen_dc, 0, 0, SRCCOPY);
//	::SetDIBitsToDevice(h_screen_dc, 0, 0, w, h, 0, 0, 0, h, p_image_data, &dib, DIB_RGB_COLORS);

	//
	int r = ::SetStretchBltMode(h_screen_dc, COLORONCOLOR);

	//
	::StretchDIBits(
						h_screen_dc,
						0+g_val1,
						0+g_val1,
						w+g_val2,
						h+g_val2,

						0+g_val3,	//sour
						0+g_val3,

						w+g_val4,	// oˡA AIoIAoAC ?ϨiAIa
						h+g_val4,
						p_image_data,
						(LPBITMAPINFO)&dib,
						DIB_RGB_COLORS,
						SRCCOPY
					);

	::SetStretchBltMode( h_screen_dc, r );



	// iˢAC ncˡEAˡI oˡCNˡU.
	::SelectObject(h_memory_dc, h_old_bitmap);

	// ˢ碮io DCˡ| A|ACNˡU.
	DeleteDC(h_memory_dc);

	// DIB AAIAC Ciˡo ϩi?eAi ˡuCNˡU.
	BITMAPFILEHEADER dib_format_layout;
	ZeroMemory(&dib_format_layout, sizeof(BITMAPFILEHEADER));
	dib_format_layout.bfType	= *(WORD*)"BM";
	dib_format_layout.bfSize	= sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + dib.bmiHeader.biSizeImage;
	dib_format_layout.bfOffBits	= sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	// ic?eCϡˡͨϨ ncˡEu DC ˡ| CA|CNˡU.
	if(NULL != h_old_bitmap)	DeleteObject(h_old_bitmap);
	if(NULL != h_bitmap)		DeleteObject(h_bitmap);
//	if(NULL != h_screen_dc)		::ReleaseDC(NULL, h_screen_dc);
//	if(NULL != dc)				::ReleaseDC(NULL, dc);


}



#define NEW_DIB_FORMAT(lpbih) (lpbih->biSize != sizeof(BITMAPCOREHEADER))
WORD DIBNumColors (LPVOID lpv)
{
    INT                 bits;
    LPBITMAPINFOHEADER  lpbih = (LPBITMAPINFOHEADER)lpv;
    LPBITMAPCOREHEADER  lpbch = (LPBITMAPCOREHEADER)lpv;

    /*  With the BITMAPINFO format headers, the size of the palette
     *  is in biClrUsed, whereas in the BITMAPCORE - style headers, it
     *  is dependent on the bits per pixel ( = 2 raised to the power of
     *  bits/pixel).
     */
    if (NEW_DIB_FORMAT(lpbih)) {
      if (lpbih->biClrUsed != 0)
        return (WORD)lpbih->biClrUsed;
      bits = lpbih->biBitCount;
    }
    else
      bits = lpbch->bcBitCount;

    if (bits > 8) 
      return 0; /* Since biClrUsed is 0, we dont have a an optimal palette */
    else
      return (1 << bits); 
}

WORD ColorTableSize (LPVOID lpv)
{
    LPBITMAPINFOHEADER lpbih = (LPBITMAPINFOHEADER)lpv;
    
    if (NEW_DIB_FORMAT(lpbih))
    {
      if (((LPBITMAPINFOHEADER)(lpbih))->biCompression == BI_BITFIELDS)
         /* Remember that 16/32bpp dibs can still have a color table */
         return (sizeof(DWORD) * 3) + (DIBNumColors (lpbih) * sizeof (RGBQUAD));
      else
         return (DIBNumColors (lpbih) * sizeof (RGBQUAD));
    }
    else
      return (DIBNumColors (lpbih) * sizeof (RGBTRIPLE));
}



HBITMAP fn_hdc2HBitmap(HDC hdc, int w, int h, int bit_count, void* pBuf)
{
	int rw							= WIDTHBYTES(bit_count*w);
	BITMAPINFO bi;
	memset(&bi, 0, sizeof(bi));
	bi.bmiHeader.biSize				= sizeof(BITMAPINFOHEADER);	//40;
	bi.bmiHeader.biWidth			= w;
	bi.bmiHeader.biHeight			= h;
	bi.bmiHeader.biPlanes			= 1;
	bi.bmiHeader.biBitCount			= bit_count;
	bi.bmiHeader.biCompression		= BI_RGB;
	bi.bmiHeader.biSizeImage		= ((w + 3) & (~3)) * h * bit_count / 8;
	bi.bmiHeader.biXPelsPerMeter	= 0;
	bi.bmiHeader.biYPelsPerMeter	= 0;

	//EnumProfiles();
//	HDC hdc			= ::GetDC(hWnd);
	//HDC hDC		= GetDC(NULL);
	//hBackDC		= CreateCompatibleDC(hdc);
	//hBackBitmap	= CreateCompatibleBitmap(hdc,320,240);
	//hBackBitmap	= CreateDIBSection(hBackDC,&bmpInfo,DIB_RGB_COLORS,&pBits,NULL,NULL);
	//hBitmap		= CreateDIBSection(hDC, &bi, DIB_RGB_COLORS, VOID **ppvBits, HANDLE hSection, DWORD dwOffset);
	HBITMAP hBitmap = CreateDIBitmap(	hdc,
										&bi.bmiHeader,
										CBM_INIT,
										pBuf,
										&bi,
										DIB_RGB_COLORS);
// 	ReleaseDC(NULL, hdc);
//	::ReleaseDC(m_hWnd,hdc);
	return hBitmap;
}

void fn_Log(int index, HDC hdc, int w, int h, BYTE* pdata)
{

	printf("-----------------------------------------------\n");
	FILE * fp;
	char buf[100];
	sprintf(&buf[0], "test%d.txt", index);
	fp = fopen(buf, "wt");
	if(fp == NULL) return ;
	
//	BYTE* pdata = (BYTE*)&pdata0;
	
//	w = 10;
//	h = 10;
	
	printf("DIB [%d] \n", index );		
	int i=0;
	int j=0;
	for(i=0; i<h; i++)
	{
		for(j=0; j<w; j++) 
		{
//					printf("%d \n", w, h, index);
		
			if(index == 0)
			{
				COLORREF cr = ::GetPixel(hdc, i, j);
				int r = GetRValue(cr);
				int g = GetGValue(cr);
				int b = GetBValue(cr);
				char c;
				c = r;
				fwrite(&c, 1, 1, fp);
				c = g;
				fwrite(&c, 1, 1, fp);
				c = b;
				fwrite(&c, 1, 1, fp);
				c = ' ';
				fwrite(&c, 1, 1, fp);
//				printf("PIX %d [%d %d %d] ", index, r, g, b );
			}
			else if(index == 1 || index == 8 || index == 9)
			{
				int pitch = 4*w; // 4 bytes per pixel but if not 32 bit, round pitch up to multiple of 4
				int pos;
				pos = j * pitch;  
				pos = j;  
		        pos += i*4;
		        
				char tmp[10];
				sprintf(&tmp[0], "%3d", pdata[pos + 0]);
				fwrite(&tmp[0], 1, 3, fp);
				sprintf(&tmp[0], "%3d", pdata[pos + 1]);
				fwrite(&tmp[0], 1, 3, fp);
				sprintf(&tmp[0], "%3d", pdata[pos + 2]);
				fwrite(&tmp[0], 1, 3, fp);
				
				char c = ' ';
				fwrite(&c, 1, 1, fp);
				
//				printf("%3d ", pdata[pos + 0] );		
//				printf("%3d ", pdata[pos + 1] );		
//				printf("%3d ", pdata[pos + 2] );	
				
			}
			else
			{
				char tmp[10];
				sprintf(&tmp[0], "%3d", pdata[(i*rwsize)+j]);
				fwrite(&tmp[0], 1, 3, fp);
				
				char c = ' ';
				fwrite(&c, 1, 1, fp);
				
//				printf("DIB %d [%d] ", index, pdata[(i*rwsize)+j] );
	//			printf("DIB %d [%d] ", index, *(p_image_data+(i*rwsize+j)));
	//					printf("%d ", *(b->p+(i*rwsize+j)));
	//					printf("%d ", b->p[i*rwsize+j]);
			}
			
		}
//		printf("\n");
	}
	printf("-----------------------------------------------\n");
//			printf("%d ", *(p_image_data+0));


	fclose(fp);
	
}






ST_BITMAP* fn_GetRGB(HWND hWnd, HDC h_screen_dc)
{
	BYTE		*	p_image_data	= NULL;
	BITMAPINFO		dib;
	RECT			rt;

	int				w;
	int				h;

	//
	::GetClientRect(hWnd, &rt);
	w = rt.right - rt.left;
	h = rt.bottom - rt.top;

	printf("HWND %x HDC %x \n", hWnd, h_screen_dc);
	
	if(key_num == 0)
	{
		fn_Log(0, h_screen_dc, w, h, NULL);
	}

	//
    ZeroMemory(&dib, sizeof(dib));
	memset(&dib.bmiHeader, 0, sizeof(BITMAPINFOHEADER));
    
  
  	int bitcount = 24;
  	
	// DIBAC CuoAAi AˢACCNˡU.
	dib.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
	dib.bmiHeader.biWidth			= w;
	dib.bmiHeader.biHeight			= -h;
	dib.bmiHeader.biPlanes			= 1;
	dib.bmiHeader.biBitCount		= bitcount;
	dib.bmiHeader.biCompression		= BI_RGB;
	dib.bmiHeader.biSizeImage		= (((w * bitcount + 31) & ~31) >> 3) * h;	///height * (DWORD)((width*biBitCount/8+3)&~3);
	dib.bmiHeader.biXPelsPerMeter	= 0;
	dib.bmiHeader.biYPelsPerMeter	= 0;
	dib.bmiHeader.biClrImportant	= 0;
	dib.bmiHeader.biClrUsed			= 0;

	// 16 bit (((Width * BitsPixel + 15) >> 4) << 1) * Height
	// 24 bit (((Width * BitsPixel + 23) >> 4) << 1) * Height
	// 32 bit (((Width * BitsPixel + 31) >> 4) << 1) * Height
	
	int rwsize = WIDTHBYTES(bitcount * w);
	int imgsize = rwsize * h;
	
	printf("%d %d %d %d %d \n", w, h, rwsize, imgsize, 3*rwsize*h);



	
	//
	HBITMAP hbitmap;
	HBITMAP hbitmap_old;
	


	//https://stackoverflow.com/questions/4722656/why-createdibsection-fails-with-certian-bitmapinfo
	HANDLE hFileReadWrite	= INVALID_HANDLE_VALUE;
	HANDLE hFileMap			= INVALID_HANDLE_VALUE;

	hFileReadWrite = CreateFile("new.bmp", GENERIC_READ|GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_NO_BUFFERING, NULL);
	if (hFileReadWrite == INVALID_HANDLE_VALUE)
	{
		return 0;
	}

//	hFileMap = CreateFileMapping(INVALID_HANDLE_VALUE, NULL, PAGE_READWRITE, 0, imgsize, NULL);
	hFileMap = CreateFileMapping(hFileReadWrite, NULL, PAGE_READWRITE, 0, imgsize, NULL);
	if (hFileMap == INVALID_HANDLE_VALUE)
	{
		return 0;
	}
	
	
	

	//
	BYTE * pMapByte = NULL;
	int iWriteByte = imgsize;
	LARGE_INTEGER now = { 0 };
	
//	pMapByte = (BYTE*)MapViewOfFile(hFileMap, FILE_MAP_READ|FILE_MAP_WRITE, now.HighPart, now.LowPart, iWriteByte);


	//
	HDC mdc = ::CreateCompatibleDC(h_screen_dc);
//	p_image_data = new BYTE [3*w*h];

	//--------------------------------------------------------------
//    h_screen_dc = GetDC(hWnd);

	// dib_define?ˢ AˢACiE ϩi?eAˡI DIBˡ| iyuCNˡU.
	hbitmap = ::CreateDIBSection(mdc, &dib, DIB_RGB_COLORS, (void **)&pMapByte, hFileMap, 0);



	//
//	hbitmap = CreateCompatibleBitmap(hdc, w, h);
	hbitmap_old	= (HBITMAP)::SelectObject(mdc, hbitmap);


	BitBlt(mdc, 0, 0, w, h, h_screen_dc, 0, 0, SRCCOPY);

	BitBlt(h_screen_dc, 0, 0, w, h, mdc, 0, 0, SRCCOPY);
//	SetDIBitsToDevice(h_screen_dc,500,0,w,h,0,0,0,h, pMapByte,(BITMAPINFO *)&dib,DIB_RGB_COLORS);


	//
//	fn_Log(1, h_screen_dc, w, h, pMapByte);

	UnmapViewOfFile(pMapByte);


	if (hFileReadWrite != INVALID_HANDLE_VALUE)
	{
		CloseHandle(hFileReadWrite);
	}

	if (hFileMap != INVALID_HANDLE_VALUE)
	{
		CloseHandle(hFileMap);
	}






	//
	if(key_num == 1)
	{
//		fn_Log(1, h_screen_dc, w, h, &p_image_data);
	}
	
	//	BitBlt(h_screen_dc, 500, 0, w, h, mdc, 0, 0, SRCCOPY);
		SetDIBitsToDevice(h_screen_dc,500,0,w,h,0,0,0,h, p_image_data,(BITMAPINFO *)&dib,DIB_RGB_COLORS);
	//pImageBufferˡ| ϩOAˡˡe EϡˡeAI COiEI Aϩϩ. AIioCIO ϩ̡?AˡU. ˢN_ˢN;;


	//--------------------------------------------------------------
	if(key_num == 2)
	{
		//
		hbitmap	= fn_hdc2HBitmap(h_screen_dc, w, h, bitcount, p_image_data);
	
//		fn_Log(2, h_screen_dc, w, h, &p_image_data);
	}
	
	
	//--------------------------------------------------------------
	if(key_num == 3)
	{
		LONG cb = rwsize*h;//w*h*3;
	//	GetBitmapBits(hbitmap, cb, p_image_data);
	
//		fn_Log(3, h_screen_dc, w, h, &p_image_data);
	}
	
	//--------------------------------------------------------------
	if(key_num == 4)
	{
		GetDIBits(h_screen_dc, hbitmap, 0, h, p_image_data, &dib, DIB_RGB_COLORS);
	
//		fn_Log(4, h_screen_dc, w, h, &p_image_data);
	}
	

	//
	SelectObject(mdc, hbitmap_old);
	DeleteObject(hbitmap);
	ReleaseDC(hWnd, mdc);
	DeleteDC(mdc);
	
	
//	GdiFlush();
	
	
/*
	if(h_bitmap == ERROR_INVALID_PARAMETER)
	{
		DWORD dw = GetLastError();
		printf("GetLastError =  %d \n", dw);
		return NULL;
	}

	ST_BITMAP b;
	b.h = h;
	b.w = w;
	b.p = p_image_data;
	b.rw = rwsize;
	return &b;	
*/

//	fn_DrawBitmap(h_screen_dc,0,0,h_bitmap);
	
	
	
	

	//--------------------------------------------------------------
	if(key_num == 5)
	{
	    LPBITMAPINFOHEADER  lpbih;
	    HPALETTE            hPalOld;
	    HDC                 hDC;
	    HBITMAP             hBitmap;  
	
	    lpbih = (LPBITMAPINFOHEADER)&dib;
	
	    if (!lpbih)
	        return NULL;
	
	//    hBitmap = CreateDIBitmap(h_screen_dc, 
	//                lpbih, 
	//                CBM_INIT, 
	//                (LPSTR)lpbih + lpbih->biSize + ColorTableSize(lpbih), 
	//                (LPBITMAPINFO)lpbih, 
	//                DIB_RGB_COLORS ); 
	
	    hBitmap = CreateDIBitmap(h_screen_dc, 
	                &dib.bmiHeader, 
	                CBM_INIT, 
	                &p_image_data, 
	                (LPBITMAPINFO)&dib, 
	                DIB_RGB_COLORS ); 
	
//		fn_Log(5, h_screen_dc, w, h, &p_image_data);
	}

	
	//--------------------------------------------------------------
	if(key_num == 6)
	{
	    BITMAPINFOHEADER   bi;
	    
		DWORD dwBmpSize = ((w * bitcount + 31) / 32) * 4 * h;
		    
	    // have greater overhead than HeapAlloc.
	    HANDLE hDIB = GlobalAlloc(GHND,dwBmpSize); 
	    char *lpbitmap = (char *)GlobalLock(hDIB);    
	
	    // Gets the "bits" from the bitmap and copies them into a buffer 
	    // which is pointed to by lpbitmap.
//	    GetDIBits(h_screen_dc, hbitmap, 0,
//	        (UINT)h,
//	        lpbitmap,
//	        (BITMAPINFO *)&bi, DIB_RGB_COLORS);	
	    GetDIBits(h_screen_dc, hbitmap, 0,
	        (UINT)h,
	        lpbitmap,
	        (BITMAPINFO *)&dib, DIB_RGB_COLORS);	
	
//		fn_Log(6, h_screen_dc, w, h, (BYTE**)lpbitmap);
		
		
	    //Unlock and Free the DIB from the heap
	    GlobalUnlock(hDIB);    
	    GlobalFree(hDIB);
	}
	
	
	
	
	//--------------------------------------------------------------
	if(key_num == 7)
	{
		ST_BITMAP * b = (ST_BITMAP*) malloc (sizeof(ST_BITMAP));
		b->h = h;
		b->w = w;
		b->rw = rwsize;
	//	b->p = p_image_data;
		
		
	
//		fn_Log(7, h_screen_dc, w, h, &p_image_data);
		
		
		//1280 1024
		//20   43
		//1260 981 3780
		//1360 1057 4080
		printf("%d %d %d \n", w, h, rwsize);
	}
	
	
	if(NULL != hbitmap)		DeleteObject(hbitmap);
	
	
	return 0;	
}



//http://forums.codeguru.com/showthread.php?526563-Accessing-Pixels-with-CreateDIBSection
BYTE* fn_GetPixel(HWND hWnd)
{
	int w	= 1280;
	int h	= 1024;
	
	HDC cdc = ::GetDC(hWnd);
	HDC hDC = cdc;
	HDC hDCMem = CreateCompatibleDC(hDC);
  
	unsigned char* lpBitmapBits;

	BITMAPINFO bi; 
	ZeroMemory(&bi, sizeof(BITMAPINFO));
	bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biWidth = w;
	bi.bmiHeader.biHeight = -h;  //negative so (0,0) is at top left
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biBitCount = 24;
	
	
	
	HBITMAP bitmap = ::CreateDIBSection(hDCMem, &bi, DIB_RGB_COLORS,  (VOID**)&lpBitmapBits, NULL, 0);
	HGDIOBJ oldbmp = ::SelectObject(hDCMem, bitmap); 

	BitBlt(hDCMem, 0, 0, w, h, hDC, 0, 0, SRCCOPY);
	//draw block
	//read data
	
	fn_Log(key_num, hDC, w, h, lpBitmapBits);

	int pitch = 4*w; // 4 bytes per pixel but if not 32 bit, round pitch up to multiple of 4
	int index;
//	h = 10;
//	w = 10;
	for(int x=0; x<h; x++)
	{
		for(int y=0; y<w; y++)
		{
			index = y * pitch;  
			index = y;  
	        index += x*4;
//	        printf("%3d ", lpBitmapBits[index + 0]);
//	        printf("%3d ", lpBitmapBits[index + 1]);
//	        printf("%3d ", lpBitmapBits[index + 2]);
//			lpBitmapBits[index + 0] = 87;  // blue
//			lpBitmapBits[index + 1] = 122; // green
//			lpBitmapBits[index + 2] = 185;  // red 
		}
//        printf("\n");
	}
	
	BitBlt(hDC, 0, 0, w, h, hDCMem, 0, 0, SRCCOPY);
	//draw image

	
	SelectObject(hDCMem,oldbmp);  
	DeleteDC(hDCMem);  
	DeleteObject(bitmap);	

	::ReleaseDC(hWnd, cdc);
	
	
}




 HANDLE h; 
 FILE * fr;



/* This is where all the input to the window goes to */
LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam) {
	
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	int MapModePrevious;
	HFONT hfont, hfontOld;
	PSTR pszFace = "MS Serif";
	RECT rt;
	
	switch(Message) 
	{
		
		case WM_CREATE:
	
			AllocConsole();
			h = GetStdHandle(STD_OUTPUT_HANDLE); 
			fr = freopen("CONOUT$", "wt", stdout);

			break;
			
			
		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			// TODO: ?Ia?ˢ ˡca AUiaˡ| AϡˢCOˡIˡU.
			

			if(key_num == 1)
			{
				
				//
				fn_JPG(hdc);
				b2 = fn_GetRGB(hwnd, hdc);
//				printf("%d %d %d \n", b2->w, b2->h, b2->rw);

				printf("key %d\n",key_num);
				
			}
			
	
			if(key_num == 8)
			{
				fn_JPG(hdc);
				BYTE* p = fn_GetPixel(hwnd);
			}
	
			
			if(key_num == 9)
			{
				hBit = MakeDIBSection("testA.bmp");
				fn_DrawBitmap(hdc,0,0,hBit);
				BYTE* p = fn_GetPixel(hwnd);
			}
	
	
			EndPaint(hwnd, &ps);
			break;
			

	case WM_KEYDOWN:
/*
- bmp -> hdc
- hdc <- data file A
- bmp -> jpg

- jpg -> hdc
- hdc -> compress data B

A - B = C Diff data
*/
		
		//
		memset(buf, 0x00, sizeof(buf));
//		sprintf(buf, "%d %d", wParam, lParam);
		sprintf(buf, "%d %d %d", HIWORD(wParam), LOWORD(wParam), lParam);
		key = LOWORD(wParam);

		printf("key %d\n",key);

		if(key >= 96 && key <= 96+9)
		{
			key_num = key-96;
		}
		if(key >= 48 && key <= 48+9)
		{
			key_num = key-48;
		}
		
		printf("key_num %d\n",key_num);
		
		
		if(key_num == 1)
		{
		}

		if(key_num == 2)
		{

		}
		
		if(key_num == 9)
		{

		}
		
		
		
		//0 == 48
		if(key == VK_ESCAPE)
		{
			SendMessage(hwnd, WM_DESTROY, 0, 0);
		}
		if(key == 'Q')
		{
			SendMessage(hwnd, WM_DESTROY, 0, 0);
		}
		//A 65 S 83
		if(key == 'A')	{	g_val0 -= 10;	}	//
		if(key == 'S')	{	g_val0 += 10;	}	//
		if(key == 'E')	{	g_val1 -= 10;	}	//
		if(key == 'R')	{	g_val1 += 10;	}	//
		if(key == 'D')	{	g_val2 -= 10;	}	//
		if(key == 'F')	{	g_val2 += 10;	}	//
		if(key == 'T')	{	g_val3 -= 10;	}	//
		if(key == 'Y')	{	g_val3 += 10;	}	//
		if(key == 'G')	{	g_val4 -= 10;	}	//
		if(key == 'H')	{	g_val4 += 10;	}	//

		::GetClientRect(hwnd, &rt);
		::InvalidateRect(hwnd, &rt, TRUE);
		break;	
			
			
		/* Upon destruction, tell the main thread to stop */
		case WM_DESTROY: {
	
			fclose(fr);
			FreeConsole();
			CloseHandle(h);
		
			PostQuitMessage(0);
			break;
		}
		
		/* All other messages (a lot of them) are processed using default procedures */
		default:
			return DefWindowProc(hwnd, Message, wParam, lParam);
	}
	return 0;
}



/* The 'main' function of Win32 GUI programs: this is where execution starts */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	WNDCLASSEX wc; /* A properties struct of our window */
	HWND hwnd; /* A 'HANDLE', hence the H, or a pointer to our window */
	MSG msg; /* A temporary location for all messages */

	/* zero out the struct and set the stuff we want to modify */
	memset(&wc,0,sizeof(wc));
	wc.cbSize		 = sizeof(WNDCLASSEX);
	wc.lpfnWndProc	 = WndProc; /* This is where we will send messages to */
	wc.hInstance	 = hInstance;
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	
	/* White, COLOR_WINDOW is just a #define for a system color, try Ctrl+Clicking it */
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszClassName = "WindowClass";
	wc.hIcon		 = LoadIcon(NULL, IDI_APPLICATION); /* Load a standard icon */
	wc.hIconSm		 = LoadIcon(NULL, IDI_APPLICATION); /* use the name "A" to use the project icon */

	if(!RegisterClassEx(&wc)) {
		MessageBox(NULL, "Window Registration Failed!","Error!",MB_ICONEXCLAMATION|MB_OK);
		return 0;
	}




   HRESULT hr;
   hr = CoInitialize(NULL);
   if(FAILED(hr))
		return 0;
		
		

	GdiplusStartupInput gdiplusStartupInput;
	ULONG_PTR pGdiToken;
    
    GdiplusStartup(&pGdiToken,&gdiplusStartupInput,NULL);



	hwnd = CreateWindowEx(WS_EX_CLIENTEDGE,"WindowClass","Caption",WS_VISIBLE|WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, /* x */
		CW_USEDEFAULT, /* y */
		1280+FRAME_W, /* width */
		1024+FRAME_H, /* height */
		NULL,NULL,hInstance,NULL);

	if(hwnd == NULL) {
		MessageBox(NULL, "Window Creation Failed!","Error!",MB_ICONEXCLAMATION|MB_OK);
		return 0;
	}

	/*
		This is the heart of our program where all input is processed and 
		sent to WndProc. Note that GetMessage blocks code flow until it receives something, so
		this loop will not produce unreasonably high CPU usage
	*/
	while(GetMessage(&msg, NULL, 0, 0) > 0) { /* If no error is received... */
		TranslateMessage(&msg); /* Translate key codes to chars if present */
		DispatchMessage(&msg); /* Send it to WndProc */
	}
	
	
	

    GdiplusShutdown(pGdiToken);
    
	CoUninitialize();

	
	return msg.wParam;
}







/*
https://www.codeproject.com/Articles/85867/A-fast-way-to-work-on-Windows-bitmap-pixel-data-wi

// FastImageManipulations.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"


int _tmain(int argc, _TCHAR* argv[])
{
//Okay Now you need a bitmap to work with. Find any bmp file on your PC and
	//Put it to C:\\1.bmp location. You can enter any name, just alter the file
	//path below:
	CImage bitmapzor;
	bitmapzor.Load(_T("C:\\1.bmp"));
	//I use ATL CImage class because it is easy to use. Low number of code lines
	//You can use HBITMAP, HGDIOBJ of GDIplus and other methods,
	//They work the same way and at the same speed, but take tons of code lines 
	//For instance you can use HBITMAP bitmapzor = (HBITMAP)ImageLoad(...)
	//And then you are to use GDI and API functions

	//Let us see the difference between standard API and pointer way:
	printf ("Now we use ATL (Api) GetPixel and SetPixel functions to enforce (for example) all green pixels by 30%\n please press any key to start and start counting minutes :)");
	getchar();
	COLORREF PixColor=0; //This is a color data
	int R=0,G=0,B=0; //These are the channel values
	//First we shall for instance allter all pixel colors to green using standard way
	for (int i=0; i<bitmapzor.GetWidth(); i++) //along line
		for (int j=0; j<bitmapzor.GetHeight(); j++) //new line
		{
			PixColor = bitmapzor.GetPixel(i,j); //This evil slow function extracts 24bit pixel color as BGR value
			R=GetRValue(PixColor);//This macro extracts red channel value
			G=GetGValue(PixColor);//This macro extracts green channel value
			B=GetBValue(PixColor);//This extracts blue pixel color

			G=(int)((float)G*1.3); //There we enforce green color by 30%.
			if (G>255) G=255; //There we ensure G is within 0-255 range
			//PixColor = B*0x10000+G*0x100+R;//We can assemble the BGR 24 bit number that way
			PixColor = RGB(R,G,B);//Or we can use this function
			bitmapzor.SetPixel(i,j,PixColor); //Now we save a new "green" pixel value back to bitmap
		}
		//Now we need to save this result to a HD:
	LPCTSTR filename=_T("C:\\GetPixel.bmp"); //you can change the location of this file
	bitmapzor.Save(filename);
	printf ("Done, file is saved to: %s\n Please press any key for another method demo", filename);
	getchar();
	
	//Okay now another way with the pointer arithmetics:
	printf ("Pointer arithmetics demo (without GetPixel and SetPixel functions): \n");
	bitmapzor.Destroy(); //Unload the changed bitmap from memory
	bitmapzor.Load("C:\\1.bmp");
	BYTE* byteptr = (BYTE*)bitmapzor.GetBits(); //this is a pointer to the exact bitmap pixel color array location
	//You can use other functions for HBITMAP and HGDIOBJ methods to find out the 
	//container for bitmap color table.
	//For instance when you use GDI and HBITMAPS, you should use
	//BYTE* byteptr = (BYTE*)(HBITMAPINFOHEADER + HBITMAPINFOHEADER->biSize); //simple pointer arithmetics
	int pitch = bitmapzor.GetPitch(); //This is a pointer offset to get new line of the bitmap
	
	for (int i=0; i<bitmapzor.GetWidth();i++)
		for (int j=0; j<bitmapzor.GetHeight();j++)
		{
			//pointer arithmetics to find (i,j) pixel colors:
			R= *(byteptr+pitch*j+3*i);
			G= *(byteptr+pitch*j+3*i+1);
			B= *(byteptr+pitch*j+3*i+2); 

			//allter pixel G color:
			G=(int)((float)G*1.3);
			if (G>255) G=255;

			//write down the new G-Color
			*(byteptr+pitch*j+3*i+1)=G;
		}
		//Save the bitmap:
		LPCTSTR filename2 = _T("C:\\ptrarithm.bmp"); //you can use any other file name
		bitmapzor.Save(filename2);
		printf ("Done, file is saved to: %s\n Please press any key to exit program", filename2);
		getchar();

	bitmapzor.Destroy(); //destroy the bitmap
	return 0;
}


*/

